#include <bits/stdc++.h>

using namespace std;

int maxi;
vector<int> bitcnt;
vector<long long> bitval;

void update(int ind, int cntdelta, long long valdelta) {
    for (int i = ind; i <= maxi; i += i & -i) {
        bitcnt[i] += cntdelta;
        bitval[i] += valdelta;
    }
}

pair<int, long long> query(int ind) {
    int c = 0;
    long long v = 0;
    for (int i = ind; i > 0; i -= i & -i) {
        c += bitcnt[i];
        v += bitval[i];
    }
    return {c, v};
}

int get_pos(long long val, const vector<long long>& coords) {
    return lower_bound(coords.begin(), coords.end(), val) - coords.begin() + 1;
}

struct Query {
    int tip;
    int x, y;
};

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr); cout.tie(nullptr);
    
    int n, q; cin >> n >> q;
    vector<int> a(n + 1);
    map<int, int> freq;
    long long cursum = 0;
    
    for (int i = 1; i <= n; ++i) {
        cin >> a[i];
        freq[a[i]]++;
        cursum += a[i];
    }
    
    vector<Query> queries(q);
    for (int i = 0; i < q; ++i) {
        cin >> queries[i].tip;
        if (queries[i].tip == 1) {
            cin >> queries[i].x;
        } else {
            cin >> queries[i].x >> queries[i].y;
        }
    }
    
    vector<long long> tezine;
    for (auto const& [val, count] : freq) {
        if (count > 0) tezine.push_back((long long)val * count);
    }
    
    map<int, int> tmpfreq = freq; 
    vector<int> tmp = a;
    
    for (int i = 0; i < q; ++i) {
        if (queries[i].tip == 2) {
            int ind = queries[i].x;
            int newval = queries[i].y;
            int oldval = tmp[ind];

            long long old_w = (long long)oldval * tmpfreq[oldval];

            tmpfreq[oldval]--;
            if (tmpfreq[oldval] > 0) {
                tezine.push_back((long long)oldval * tmpfreq[oldval]);
            }


            tmpfreq[newval]++;
            tezine.push_back((long long)newval * tmpfreq[newval]);
            
            tmp[ind] = newval;
        }
    }
    
    sort(tezine.begin(), tezine.end());
    tezine.erase(unique(tezine.begin(), tezine.end()), tezine.end());
    
    maxi = tezine.size();
    bitcnt.assign(maxi + 1, 0);
    bitval.assign(maxi + 1, 0);

    int distinctcount = 0;
    for (auto const& [val, count] : freq) {
        long long w = (long long)val * count;
        int pos = get_pos(w, tezine);
        update(pos, 1, w);
        distinctcount++;
    }
    
    for (int i = 0; i < q; ++i) {
        if (queries[i].tip == 1) {
            int k = queries[i].x;

            
            int kills = n - k;
            if (kills < 0) kills = 0; 
            int perform = min(distinctcount, kills);
            
            long long sumremoved = 0;

            if (perform > 0) {

                int keepbottom = distinctcount - perform;
                
                if (keepbottom == 0) {
                    sumremoved = query(maxi).second;
                } else {

                    int l = 1, r = maxi, foundind = -1;
                    while (l <= r) {
                        int mid = l + (r - l) / 2;
                        if (query(mid).first >= keepbottom) {
                            foundind = mid;
                            r = mid - 1;
                        } else {
                            l = mid + 1;
                        }
                    }
                    
                    pair<int, long long> low_part = query(foundind);
                    pair<int, long long> total = query(maxi);

                    
                    int overflow = low_part.first - keepbottom;
                    long long sumbottom = low_part.second - (long long)overflow * tezine[foundind - 1];
                    
                    sumremoved = total.second - sumbottom;
                }
            }
            
            cout << cursum - sumremoved << "\n";

        } else {
            int ind = queries[i].x;
            int y = queries[i].y;
            int oldval = a[ind];

            if (oldval == y) continue;

            long long oldw = (long long)oldval * freq[oldval];
            int posold = get_pos(oldw, tezine);
            update(posold, -1, -oldw);
            distinctcount--; 

            freq[oldval]--;
            cursum -= oldval;

            if (freq[oldval] > 0) {
                long long neww = (long long)oldval * freq[oldval];
                int pos = get_pos(neww, tezine);
                update(pos, 1, neww);
                distinctcount++;
            }

            if (freq[y] > 0) {
                long long oldwy = (long long)y * freq[y];
                int pos = get_pos(oldwy, tezine);
                update(pos, -1, -oldwy);
                distinctcount--;
            }

            freq[y]++;
            cursum += y;
            a[ind] = y;

            long long newwy = (long long)y * freq[y];
            int posnew = get_pos(newwy, tezine);
            update(posnew, 1, newwy);
            distinctcount++;
        }
    }

    return 0;
}